/*
 * WiFi utility for NV
 *
 * Copyright (C) 2011, Huawei
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>

#define BALONG_NV_DEV               "/proc/OmNv"
#define MAX_PRINT_LEN               1024
#define WIFI_STARTFLAG_NV_LEN       sizeof(int)
#define WIFI_STARTFLAG_NV_ITEM      36
#define WIFI_STARTUP_TCMD_MODE      0
#define WIFI_STARTUP_NOR_MODE       1
#define NV_APP_HEAD_LEN             8
#define OK		      (0)
#define ERROR		    (1)

#define NV_APP_HEAD         unsigned short	usNvId;\
	                          unsigned short	usLength;\
	                          unsigned long   ulResult;


typedef struct
{
    NV_APP_HEAD
    unsigned char	aucData[MAX_PRINT_LEN];
}NV_APP_DATA_STRU;


/* Main client function */
int
main(int argc, char **argv)
{
    int ret = 0; // default value, meaning wifi should be startup in normal mode;
    NV_APP_DATA_STRU stData = {0};
    int iNvFd=-1, iReadLen=-1,i=0;

    
    while(i<100)
    {
    	sleep(1);
        iNvFd = open(BALONG_NV_DEV, O_RDWR);
        if(iNvFd < 0)
        {
	    i++;
            continue;
        }
	break;
    }
    if(100 == i)
    {
        printf("Cannot open Omnv file!!!\n");
	return -1;
    }
    stData.usNvId   = WIFI_STARTFLAG_NV_ITEM;
    stData.usLength = (unsigned short)WIFI_STARTFLAG_NV_LEN;
    stData.ulResult = ERROR;

    /*get the NV value*/
    i=0;
    while(iReadLen<0&&i<100)
    {
    	sleep(1);
	i++;
        iReadLen = read(iNvFd,(char*)&stData,NV_APP_HEAD_LEN+WIFI_STARTFLAG_NV_LEN);
    }
    close(iNvFd);
    if(100==i)
    {
        printf("cannot read nv data!!!\n");
    	return -1;
    }
    printf("----stData.aucData=%s",stData.aucData);
 /*   if(iReadLen <= 0)
    {
        printf("read  NV36 (wifi startup flag) failed!\n");
        return ret;        
    }*/   //libinbin,ԣ˴Ϊ0ȷ
    
    if(ERROR != stData.ulResult)
    {
        if(WIFI_STARTUP_TCMD_MODE == (*(unsigned int*)stData.aucData))
        {
            return 1;
        }
        else if(WIFI_STARTUP_NOR_MODE == (*(unsigned int*)stData.aucData))
        {
	    return 0;
        }
        else
        {
            return -1;
        }
    }

    return -1;	    
}
