/******************************************************************************

                  Ȩ (C), 2001-2011, Ϊ޹˾

 ******************************************************************************
       : IMMmem.h
       : 
     : 2011129
  ޸   :
     : IMM.c ͷļ
  б   :
  ޸ʷ   :
  1.       : 2011129
    ޸   : ļ

******************************************************************************/

#ifndef __IMM_MEM_H__
#define __IMM_MEM_H__

/*****************************************************************************
  1 ͷļ
*****************************************************************************/
#include <generated/FeatureConfigTTF.h>
#include <generated/TtfMemoryMap.h>
#include <linux/skbuff.h>


#ifdef __cplusplus
#if __cplusplus
extern "C" {
#endif
#endif




#pragma pack(4)

/*****************************************************************************
  2 궨
*****************************************************************************/
#define FEATURE_IMM_MEM_DEBUG           (FEATURE_TTF_MEM_DEBUG)

/* IMM ڴؿܵ󳤶 */
#define IMM_MEM_BLK_MAX_BYTE_LEN        (1953)

/* IMM ڴؿܵ൵λ */
#define IMM_MEM_BLK_MAX_CLUSTER_NUM     (8)

/* IMM ͷڴָ */
#define IMM_ADD_CTL_HEAD_MEM(pstImmHead, pMem)          ((pstImmHead)->p_Imm_Ttf_Mem = (pMem))

#define IMM_GET_4BYTE_ALIGN_VALUE(ulSize)   ( ((ulSize) + 0x03) & (~0x03) )

#define IMM_CACHE_INVALID(data, len) __dma_single_dev_to_cpu_nocheck(data, len, DMA_FROM_DEVICE)
#define IMM_CACHE_FLUSH(data, len) __dma_single_cpu_to_dev_nocheck(data, len, DMA_TO_DEVICE)

/*****************************************************************************
  3 öٶ
*****************************************************************************/
#define IMM_DEBUG_TRACE_FUNC            FEATURE_OFF
extern unsigned char                    g_ucImmMemDebugPrint;


#ifdef _lint

#define IMM_DEBUG_TRACE_FUNC_ENTER()
#define IMM_DEBUG_TRACE_FUNC_LEAVE()

#else

#if(IMM_DEBUG_TRACE_FUNC == FEATURE_ON)

#ifdef __UT_CENTER__
#define __func__ __FUNCTION__
#endif

/* Դӡ */
/*
#define IMM_DEBUG_PRINT(...)\
             do{\
                 if ( PS_TRUE == g_ucMemDebugPrint )\
                 {\
                     vos_printf(__VA_ARGS__);
                 }\
             }while(0)
*/


#define IMM_DEBUG_TRACE_FUNC_ENTER()\
                do{\
                    if ( IMM_TRUE == g_ucImmMemDebugPrint )\
                    {\
                        printk("Enter Function: ");\
                        printk(__func__);\
                        printk("\n");\
                    }\
                }while(0)

#define IMM_DEBUG_TRACE_FUNC_LEAVE()\
                do{\
                    if ( IMM_TRUE == g_ucImmMemDebugPrint )\
                    {\
                        printk("Normal Leave Function: ");\
                        printk(__func__);\
                        printk("\n");\
                    }\
                }while(0)
#else
#define IMM_DEBUG_TRACE_FUNC_ENTER()
#define IMM_DEBUG_TRACE_FUNC_LEAVE()
#endif
#endif

/*****************************************************************************
 ö    : IMM_BOOL_ENUM
 Э  :
 ASN.1 :
 ö˵  : IMMͳһöٶ
*****************************************************************************/
enum IMM_BOOL_ENUM
{
    IMM_FALSE                            = 0,
    IMM_TRUE                             = 1,
    IMM_BOOL_BUTT
};
typedef unsigned char   IMM_BOOL_ENUM_UINT8;

/*****************************************************************************
 ö    : IMM_RSLT_CODE_ENUM
 Э  :
 ASN.1 :
 ö˵  : IMM ͳһֵöٶ
*****************************************************************************/
enum IMM_RSLT_CODE_ENUM
{
    IMM_SUCC                             = 0,
    IMM_FAIL                             = 1,
};
typedef unsigned long   IMM_RSLT_CODE_ENUM_UINT32;

/*****************************************************************************
 ṹ    : IMM_MEM_USED_INFO_TRIG_TYPE_ENUM_UINT8
 Э  :
 ASN.1 :
 ṹ˵  : IMM MEMڴϢϱ

1.     : 20111128
  ޸ : ½
*****************************************************************************/
enum IMM_MEM_USED_INFO_TRIG_TYPE_ENUM
{
    IMM_MEM_TRIG_TYPE_ALERT                      = 0x0,     /*ڴ泬޸澯*/
    IMM_MEM_TRIG_TYPE_ALLOC_FAIL,                           /*ڴʧ*/
    IMM_MEM_TRIG_TYPE_LEAK,                                 /*鵽ڴй¶*/
    IMM_MEM_TRIG_TYPE_OVERTIME_OCCUPANCY,                   /* ⵽ڴ汻ʱʹ */
    IMM_MEM_TRIG_TYPE_BUTT
};
typedef unsigned char IMM_MEM_USED_INFO_TRIG_TYPE_ENUM_UINT8;

/*****************************************************************************
  4 ȫֱ
*****************************************************************************/

/*****************************************************************************
  5 Ϣͷ
*****************************************************************************/


/*****************************************************************************
  6 Ϣ
*****************************************************************************/


/*****************************************************************************
  7 STRUCT
*****************************************************************************/



/*****************************************************************************
 ṹ    : MEM_BLK_STATE_ENUM_UINT32
 Э  :
 ASN.1 :
 ṹ˵  : ڴʹ״̬

1.     : 20111128
  ޸ : ½
*****************************************************************************/
enum MEM_BLK_STATE_ENUM
{
    MEM_BLK_STATE_FREE,       /*ڴδͷ*/
    MEM_BLK_STATE_ALLOC,      /*ڴ*/
    MEM_BLK_STATE_BUTT
};
typedef unsigned long MEM_BLK_STATE_ENUM_UINT32;


/*****************************************************************************
 ṹ    : IMM_BLK_MEM_DEBUG_STRU
 Э  :
 ASN.1 :
 ṹ˵  : ڴάɲ洢ṹ

1.     : 20111128
  ޸ : ½
*****************************************************************************/
typedef struct
{
    MEM_BLK_STATE_ENUM_UINT32           enMemStateFlag;
    unsigned long                       ulAllocTick;        /* CPU tick when alloc or free */
    unsigned short                      usAllocFileID;      /* File ID when alloc or free */
    unsigned short                      usAllocLineNum;     /* File Line when alloc or free */
    unsigned short                      usTraceFileID;      /* File ID when traced */
    unsigned short                      usTraceLineNum;     /* File Line when traced */
    unsigned long                       ulTraceTick;        /* CPU tick when traced */
} IMM_BLK_MEM_DEBUG_STRU;


/*****************************************************************************
 ṹ    : IMM_MEM_POOL_ID_ENUM_UINT8
 Э  :
 ASN.1 :
 ṹ˵  : IMM MEMڴ

1.     : 20111128
  ޸ : ½
*****************************************************************************/
enum IMM_MEM_POOL_ID_ENUM
{
    IMM_MEM_POOL_ID_SHARE = 0,              /* A˹ڴID */
    IMM_MEM_POOL_ID_EXT,                    /* AⲿڴID */

    IMM_MEM_POOL_ID_BUTT
};
typedef unsigned char IMM_MEM_POOL_ID_ENUM_UINT8;


/*****************************************************************************
 ṹ    : IMM_MEM_POOL_ID_ENUM_UINT8
 Э  :
 ASN.1 :
 ṹ˵  : IMM MEMڴ

1.     : 20111128
  ޸ : ½
*****************************************************************************/
enum IMM_MEM_TYPE_ID_ENUM
{
    IMM_MEM_TYPE_ID_SHARE = 0,              /* A˹ڴ */
    IMM_MEM_TYPE_ID_EXT,                    /* C˵Ŀڴ */

    IMM_MEM_TYPE_ID_BUTT
};
typedef unsigned char IMM_MEM_TYPE_ID_ENUM_UINT8;


/*****************************************************************************
 ṹ    : IMM_INVALID_MEM_TYPE_ENUM_UINT8
 Э  :
 ASN.1 :
 ṹ˵  : IMM MEMڴǷ

1.     : 20111128
  ޸ : ½
*****************************************************************************/
enum IMM_INVALID_MEM_TYPE_ENUM
{
    IMM_INVALID_MEM_TYPE_MAGICNUM = 1,              /* ڴħִ */
    IMM_INVALID_MEM_TYPE_POOLID,                    /* ڴIDǷ  */
    IMM_INVALID_MEM_TYPE_CTRLADDR,                  /* ڴַǷ */
    IMM_INVALID_MEM_TYPE_STUTAS,                    /* ڴ״̬ */

    IMM_INVALID_MEM_TYPE_BUTT
};
typedef unsigned char IMM_INVALID_MEM_TYPE_ENUM_UINT8;

/*****************************************************************************
 ṹ    : IMM_MEM_STRU
 Э  :
 ASN.1 :
 ṹ˵  : IMM ڴͷṹ

1.     : 20111128
  ޸ : ½
*****************************************************************************/
typedef struct
{
    IMM_MEM_POOL_ID_ENUM_UINT8          enPoolId;           /* ڴĸڴ */
    unsigned char                       ucClusterId;        /* ڴһ */
    unsigned short                      usMagicNum;         /* ڴƿħ */
#if(FEATURE_ON==FEATURE_IMM_MEM_DEBUG)
    IMM_BLK_MEM_DEBUG_STRU              stDbgInfo;         /* ڴƿDEBUGϢ洢 */
#endif
    unsigned char                      *pstMemBlk;          /* ݵָ룬ָṹڴ */
}IMM_MEM_STRU;


/*****************************************************************************
 ṹ    : IMM_MEM_CLUSTER_STRU
 Э  :
 ASN.1 :
 ṹ˵  : IMM MEMÿڴĹṹ

1.     : 20111128
  ޸ : ½
*****************************************************************************/
typedef struct
{
    /*IMM_MEM_STRUܸ*/
    unsigned short                      usTotalCnt;

    /*IMM_MEM_STRUи*/
    unsigned short                      usFreeCnt;

    /*ڴݳ*/
    unsigned short                      usLen;

    unsigned char                       aucRsv[2];

    /*¼IMM_MEM_STڴջԪأΪIMM_MEM_STָ */
    IMM_MEM_STRU                      **apstFreeStack;
}IMM_MEM_CLUSTER_STRU;



typedef void (*IMM_MEM_EVENT_CALLBACK)(unsigned long ulMaxClusterFreeCnt);
typedef void (*IMM_MEM_EXT_FREE_CALLBACK)(void *pAddr);
typedef void (*IMM_MEM_USED_INFO_EVENT_RPT_CALLBACK)( unsigned char  ucPoolId, IMM_MEM_USED_INFO_TRIG_TYPE_ENUM_UINT8 enTrigType );
typedef unsigned long (*IMM_OM_GET_SLICE_CALLBACK)(void);

/*****************************************************************************
 ṹ    : IMM_MEM_POOL_STRU
 Э  :
 ASN.1 :
 ṹ˵  : IMMڴؿƽṹ

1.     : 20111128
  ޸ : ½
*****************************************************************************/
typedef struct
{
    /* ʶڴǷʹ */
    unsigned char                       ucUsedFlag;

    /* ڴһжټ*/
    unsigned char                       ucClusterCnt;

    /* ڴʹõûֽ */
    unsigned short                      usMaxByteLen;

    /* ָ򳤶ָ */
    unsigned char                       aucLenIndexTable[IMM_MEM_BLK_MAX_BYTE_LEN];

    /* ָָ */
    IMM_MEM_CLUSTER_STRU                astClusterTable[IMM_MEM_BLK_MAX_CLUSTER_NUM];

    unsigned short                      usImmMemTotalCnt;       /* ڴһжIMM_MEM_ST */
    unsigned short                      usImmMemUsedCnt;        /* ʹ˶IMM_MEM_ST */

    unsigned short                      usImmExcThresholdCnt;   /* ڴʧܳ޴ */
    unsigned short                      usImmAllocFailCnt;      /* һιڴʧܴ */

    unsigned long                       ulImmMemMaxBlkCcpuUsedCnt; /* ߵA˴C˵Ŀ */

    IMM_MEM_STRU                       *pstImmMemStStartAddr;   /* ָImmMemST׵ַָ */
    IMM_MEM_EVENT_CALLBACK              pMemAllocEvent;
    IMM_MEM_EVENT_CALLBACK              pMemFreeEvent;
    IMM_MEM_EXT_FREE_CALLBACK           pMemExtFreeFunc;        /* ָⲿעͷź*/
} IMM_MEM_POOL_STRU;


/*****************************************************************************
 ṹ    : IMM_MEM_CLUSTER_CFG_INFO_STRU
 Э  :
 ASN.1 :
 ṹ˵  : IMM MEMÿϢ

1.     : 20111128
  ޸ : ½
*****************************************************************************/
typedef struct
{
    unsigned short                          usSize;    /* ĴС */
    unsigned short                          usCnt;     /*  */
}IMM_MEM_CLUSTER_CFG_INFO_STRU;


/*****************************************************************************
 ṹ    : IMM_MEM_POOL_CFG_INFO_STRU
 Э  :
 ASN.1 :
 ṹ˵  : IMM MEMÿڴصļϢ

1.     : 20111128
  ޸ : ½
*****************************************************************************/
typedef struct
{
    IMM_MEM_POOL_ID_ENUM_UINT8          enPoolId;           /*  ID */
    unsigned char                       ucClusterCnt;       /* ڴжټ */
    unsigned char                       aucResv[2];

    IMM_MEM_CLUSTER_CFG_INFO_STRU      *pstClusterCfgInfo;  /* ÿľϢ */
} IMM_MEM_POOL_CFG_INFO_STRU;


/*****************************************************************************
 ṹ    : IMM_MEM_REG_MNTN_FUNC_STRU
 Э  :
 ASN.1 :
 ṹ˵  : IMM MEMעάɲṹ

1.     : 20111128
  ޸ : ½
*****************************************************************************/
typedef struct
{
    IMM_OM_GET_SLICE_CALLBACK                   pImmOmGetSliceFunc;   /* ȡCPU CLICE עắָ */
    IMM_MEM_USED_INFO_EVENT_RPT_CALLBACK        pImmMemEventRptFunc;  /* ϱڴ¼עắָ */
}IMM_MEM_REG_MNTN_FUNC_STRU;

/*****************************************************************************
 ṹ    : IMM_MEM_FREE_NULL_PTR_INFO_STRU
 Э  :
 ASN.1 :
 ṹ˵  : IMM MEM FREEյָϢ
*****************************************************************************/
typedef struct IMM_MEM_FREE_NULL_PTR_INFO
{
    unsigned long           ulImmMemFreeNullPtrCnt;     /* ImmMemFree յָ */
    unsigned short          usImmMemFreeFileId;         /* ImmMemFree յָļIDһյָļIDϢ */
    unsigned short          usImmMemFreeLineNum;        /* ImmMemFree յָļIDһյָкϢ */
}IMM_MEM_FREE_NULL_PTR_INFO_STRU;

/*****************************************************************************
 ṹ    : IMM_MEM_FREE_INVALIED_MEM_INFO_STRU
 Э  :
 ASN.1 :
 ṹ˵  : IMM MEM FREE յķǷIMM MEM ڴϢ
*****************************************************************************/
typedef struct IMM_MEM_FREE_INVALIED_MEM_INFO
{
    unsigned long                           ulInvalidImmMemCnt;         /* IMM MEM FREE յķǷڴ */
    unsigned long                           ulInvalidImmMemAddr;        /* IMM MEM FREE һյķǷIMM MEM ڴַ */
    unsigned short                          usImmMemFreeFileId;         /* IMM MEM FREE һյķǷIMM MEM ڴļIDϢ */
    unsigned short                          usImmMemFreeLineNum;        /* IMM MEM FREE һյķǷIMM MEM ڴкϢ */
    IMM_INVALID_MEM_TYPE_ENUM_UINT8         ucImmMemInvalidType;        /* IMM MEM FREE һյķǷIMM MEM ڴϢ */
    unsigned char                           aucReserve[1];              /*  */
    unsigned short                          usImmMemInvalidValue;       /* IMM MEM FREE һյķǷIMM MEM ڴֵ */
}IMM_MEM_FREE_INVALIED_MEM_INFO_STRU;

/*****************************************************************************
 ṹ    : IMM_MEM_FREE_MNTN_INFO_STRU
 Э  :
 ASN.1 :
 ṹ˵  : IMM ڴͷſάɲϢ
*****************************************************************************/
typedef struct IMM_MEM_FREE_MNTN_INFO
{
    IMM_MEM_FREE_INVALIED_MEM_INFO_STRU astImmMemFreeInvalidMemInfo;    /* IMM MEM FREE յķǷIMM MEM ڴϢ */
    IMM_MEM_FREE_NULL_PTR_INFO_STRU     astImmMemFreeNullPtrInfo;       /* IMM MEM FREE յһָΪյϢ */
    IMM_MEM_FREE_NULL_PTR_INFO_STRU     astImmMemFreeNullPPtrInfo;      /* IMM MEM FREE յָΪյϢ */
    unsigned long                       ulImmMemExtFreeFailCnt;         /* IMM MEM ͷⲿڴʧܴ */
}IMM_MEM_FREE_MNTN_INFO_STRU;

/*****************************************************************************
  8 UNION
*****************************************************************************/


/*****************************************************************************
  9 OTHERS
*****************************************************************************/
extern IMM_MEM_POOL_STRU                        g_astImmMemPool[IMM_MEM_POOL_ID_BUTT];
extern IMM_MEM_POOL_STRU * const                g_pstImmExtMemPool;
extern const IMM_MEM_CLUSTER_CFG_INFO_STRU      g_astImmMemCtrlPoolClusterTableInfo[];
extern const unsigned long * const              g_pulImmMemCtrlMemSuffix;
extern const unsigned long * const              g_paulImmMemCtrlMemSpace;
extern unsigned short                           g_usImmAllocFailCntThreshold;
extern unsigned short * const                   g_apusImmExcThresholdCnt[];
extern unsigned short * const                   g_apusImmAllocFailCnt[];
extern IMM_MEM_FREE_MNTN_INFO_STRU              g_stImmMemFreeMntnEntity;

/*****************************************************************************
  10 
*****************************************************************************/
extern IMM_MEM_STRU *IMM_MemAlloc_Debug(unsigned short usFileID, unsigned short usLineNum,
                    unsigned char ucPoolId, unsigned int ulLen);

extern void IMM_MemFree_Debug(unsigned char * pucFileId, unsigned short usLineNum, IMM_MEM_STRU **pstMem);

extern void IMM_MemRegMntnFuncCallBack
(
    IMM_OM_GET_SLICE_CALLBACK   pImmOmGetSliceFunc,
    IMM_MEM_USED_INFO_EVENT_RPT_CALLBACK    pImmMemEventRptFunc
);

extern  unsigned long IMM_MemRegExtFreeCallBack
(
    IMM_MEM_EXT_FREE_CALLBACK           pMemExtFreeFunc
);

extern  unsigned long IMM_MemBlkInit(void);
extern  IMM_MEM_POOL_STRU *IMM_MemPoolGet(unsigned char ucPoolId);
extern void IMM_ZcInit(void);

extern void IMM_MemFreeShowMntnInfo(void);

#define IMM_MemFree(pstMem)             IMM_MemFree_Debug(__FILE__, __LINE__, &(pstMem))

/* IMM MEM ȡڴָ */
#define IMM_MEM_GET_POOL(ucPoolId)      (&g_astImmMemPool[(ucPoolId)])

#define IMM_MEM_CTRL_HEAD_ALLOC(usFileID, usLineNum)\
    IMM_MemAlloc_Debug(usFileID, usLineNum, IMM_MEM_POOL_ID_EXT, 0 )


#if ( FEATURE_IMM_MEM_DEBUG == FEATURE_ON )
extern struct sk_buff *dev_alloc_skb_exp_debug(unsigned short usFileID, unsigned short usLineNum,
                        unsigned int ulLen);
#define    dev_alloc_skb_static(ulLen)\
         dev_alloc_skb_exp_debug(THIS_FILE_ID, __LINE__, ulLen)
#else
#define    dev_alloc_skb_static(ulLen)\
         dev_alloc_skb_exp(ulLen)
#endif


#if((defined(VERSION_V3R2)) && (FEATURE_WIFI == FEATURE_ON ))
#if ( FEATURE_IMM_MEM_DEBUG == FEATURE_ON )
#define    dev_alloc_skb_staticForWifi(ulLen)\
         dev_alloc_skb_ForWifi_debug(THIS_FILE_ID, __LINE__, ulLen)
#else
#define    dev_alloc_skb_staticForWifi(ulLen)\
         dev_alloc_skb_ForWifi(ulLen)
#endif
#endif



#pragma pack(0)



#ifdef __cplusplus
    #if __cplusplus
        }
    #endif
#endif

#endif /* end of IMM.h */

