/****************************************************************************
 *  (c) Copyright 2007 Wi-Fi Alliance.  All Rights Reserved
 *
 *
 *  LICENSE
 *
 *  License is granted only to Wi-Fi Alliance members and designated
 *  contractors ($B!H(BAuthorized Licensees$B!I(B)..AN  Authorized Licensees are granted
 *  the non-exclusive, worldwide, limited right to use, copy, import, export
 *  and distribute this software:
 *  (i) solely for noncommercial applications and solely for testing Wi-Fi
 *  equipment; and
 *  (ii) solely for the purpose of embedding the software into Authorized
 *  Licensee$B!G(Bs proprietary equipment and software products for distribution to
 *  its customers under a license with at least the same restrictions as
 *  contained in this License, including, without limitation, the disclaimer of
 *  warranty and limitation of liability, below..AN  The distribution rights
 *  granted in clause
 *  (ii), above, include distribution to third party companies who will
 *  redistribute the Authorized Licensee$B!G(Bs product to their customers with or
 *  without such third party$B!G(Bs private label. Other than expressly granted
 *  herein, this License is not transferable or sublicensable, and it does not
 *  extend to and may not be used with non-Wi-Fi applications..AN  Wi-Fi Alliance
 *  reserves all rights not expressly granted herein..AN 
 *.AN 
 *  Except as specifically set forth above, commercial derivative works of
 *  this software or applications that use the Wi-Fi scripts generated by this
 *  software are NOT AUTHORIZED without specific prior written permission from
 *  Wi-Fi Alliance.
 *.AN 
 *  Non-Commercial derivative works of this software for internal use are
 *  authorized and are limited by the same restrictions; provided, however,
 *  that the Authorized Licensee shall provide Wi-Fi Alliance with a copy of
 *  such derivative works under a perpetual, payment-free license to use,
 *  modify, and distribute such derivative works for purposes of testing Wi-Fi
 *  equipment.
 *.AN 
 *  Neither the name of the author nor "Wi-Fi Alliance" may be used to endorse
 *  or promote products that are derived from or that use this software without
 *  specific prior written permission from Wi-Fi Alliance.
 *
 *  THIS SOFTWARE IS PROVIDED BY WI-FI ALLIANCE "AS IS" AND ANY EXPRESS OR
 *  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY, NON-INFRINGEMENT AND FITNESS FOR A.AN PARTICULAR PURPOSE,
 *  ARE DISCLAIMED. IN NO EVENT SHALL WI-FI ALLIANCE BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *  (INCLUDING, BUT NOT LIMITED TO, THE COST OF PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *  STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE) ARISING IN ANY WAY OUT OF
 *  THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. ******************************************************************************
 */
 
 /*
 * wfa_tg.h:
 *   Definitions used in Traffic Generator Modules
 */
#ifndef _WFA_TG_H
#define _WFA_TG_H

#ifndef WIN32
#include <sys/time.h>
#include <pthread.h>
#include <bcmendian.h>
#else
#include <windows.h>
#ifdef WFA_WMM_EXT
#ifndef WIN32
#include "sched.h"
#include "semaphore.h"
#endif /* !WIN32 */
#endif /* WFA_WMM_EXT */

#define usleep(x)	Sleep(x)
#define sleep(x)	Sleep(x)
#endif /* !WIN32 */

/* maximum number of streams to support */
//#define WFA_MAX_WMM_STREAMS            4 
#define IPV4_ADDRESS_STRING_LEN    16

#define  MAX_PROFILE_NUM        6
#define  MINISECONDS            1000
#define  MICROSECONDS           1000000
#define  NANOSECONDS            1000000000
#define  LINUX_TIMER_RES        20000000      /* 20 MINSECONDS */
#define  CA_RESPONSE_BUF_SIZE   128

/* Profile Key words */
#define KW_PROFILE                 1 
#define KW_DIRECTION               2
#define KW_DIPADDR                 3
#define KW_DPORT                   4
#define KW_SIPADDR                 5
#define KW_SPORT                   6
#define KW_FRATE                   7
#define KW_DURATION                8
#define KW_PLOAD                   9
#define KW_TCLASS                  10
#define KW_STREAMID                11
#define KW_COMPLETE                12
#define KW_ERROR                   13
#define KW_STARTDELAY              14
#define KW_NUMFRAME                15
#define KW_USESYNCCLOCK            16

/* Profile Types */
#define PROF_FILE_TX               1
#define PROF_MCAST                 2
#define PROF_IPTV                  3
#define PROF_TRANSC                4
#define PROF_START_SYNC            5
#define PROF_FINISH_SYNC           6
#define PROF_UAPSD                 7
#define PROF_LAST                  8

/* Traffic Classes */
//#define TRAFFIC_CLASS_VO           1
//#define TRAFFIC_CLASS_VI           2
//#define TRAFFIC_CLASS_BK           3 
//#define TRAFFIC_CLASS_BE           4


/* Traffic Directions */
#define DIRECT_SEND                1 
#define DIRECT_RECV                2 

#define TG_PROTO_TCP               0 
#define TG_PROTO_UDP               1

#define TG_WMM_AC_BE          1      /* Best Effort */
#define TG_WMM_AC_BK          2      /* Background  */
#define TG_WMM_AC_VI          3      /* Video       */
#define TG_WMM_AC_VO          4      /* Voice       */
#define TG_WMM_AC_UAPSD       5      /* UAPSD        */

/* wmm defs */
#define TOS_VO7     0xE0         // 111 0  0000 (7)  AC_VO tos/dscp values
#define TOS_VO      0xD0         // 110 0  0000 (6)  AC_VO tos/dscp values
//Atheros Madwifi use 0x88 for UPSD/Voice
//#define TOS_VO      0x88       // 110 0  0000 (6)  AC_VO tos/dscp values

#define TOS_VI      0xA0         // 101 0  0000 (5)  AC_VI
#define TOS_VI4     0x80         // 100 0  0000 (4)  AC_VI

#define TOS_BE      0x00         // 000 0  0000 (0)  AC_BE
#define TOS_EE      0x60         // 011 0  0000 (3)  AC_BE

#define TOS_BK      0x20         // 001 0  0000 (1)  AC_BK
#define TOS_LE      0x40         // 010 0  0000 (2)  AC_BK

#define AC_CLASS_MAX_THREAD        5

#define WFA_UDP_ECHO_STREAM_ID    0xFFFF
#define WFA_UDP_ECHO_PORT         07

#define WFA_PING_ICMP_ECHO         0
#define WFA_PING_UDP_ECHO          1

typedef struct _tg_profile
{
    int  profile;                           /* profile id                    */
    int  direction;
    char dipaddr[IPV4_ADDRESS_STRING_LEN];  /* destination/remote ip address */
    unsigned short  dport;
    char sipaddr[IPV4_ADDRESS_STRING_LEN];  /* source/local ip address       */
    unsigned short  sport;
    int  rate;
    int  duration;
    int  pksize;
    short trafficClass;      /* VO, VI, BK, BE */
    int  startdelay;
} tgProfile_t;

typedef struct _tg_stats
{
    int txFrames;
    int rxFrames;
    int txPayloadBytes;
    int rxPayloadBytes;
    int outOfSequenceFrames; 
    int lostPkts;                 /* voice over wi-fi */
    unsigned long jitter;         /* voice over wi-fi */
} tgStats_t;

typedef struct _tg_stream
{
    int id;
    int sockfd;
    int tblidx;
    int lastPktSN;        /* use for Jitter calculation */
    int rxTimeLast;       /* use for pkLost             */
    int fmInterval;       
    int state;            /* indicate if the stream being active */
    tgProfile_t profile;
    tgStats_t stats;
} tgStream_t;

typedef struct _traffic_header
{
   char hdr[20];   /* always wfa */
} tgHeader_t;

#ifdef WFA_WMM_EXT
typedef struct _tg_wmm
{
    int thr_flag;    /* this is used to indicate stream id */
    int stop_flag;    /* this is used to indicate stream id */
#ifndef WIN32
	int thr_id;
	pthread_t thr;
    pthread_cond_t thr_flag_cond;
    pthread_cond_t thr_stop_cond;
    pthread_mutex_t thr_flag_mutex;
    pthread_mutex_t thr_stop_mutex;
#else
	HANDLE thr_id;
#endif /*!WIN32 */
}tgWMM_t;

typedef int (*StationStateFunctionPtr)( char, int,int *); //PS,sleep period,state

typedef struct station_state_table
{
StationStateFunctionPtr statefunc;
char                    pw_offon;
int                     sleep_period;
} StationProcStatetbl_t;

typedef int (*stationRecvStateFunctionPtr)(unsigned int *, int,int * ); //Recieved message buffer, length,state

typedef struct console_rcv_state_table
{
stationRecvStateFunctionPtr statefunc;
} StationRecvProcStatetbl_t;
#endif /* WFA_WMM_EXT */

typedef struct _tg_thr_data
{
   int tid;
#ifdef WFA_WMM_PS_EXT
   /* In case of XP CA the library does not get compiled with WFA_WMM_PS_EXT 
    * Hence StationProcStatetbl_t definition will not be known to XP.
    */
   StationProcStatetbl_t  *state;
#endif  /* WFA_WMM_PS_EXT */
   int state_num;   
} tgThrData_t;

typedef struct _tg_sync_time
{
   double dut_time;
   double tm_time;
   double dtime;
}tgSyncTime_t;

typedef struct _e2e_stats
{
   int seqnum;
   int lsec;
   int lusec;
   int rsec;
   int rusec;
} tgE2EStats_t;

extern int wfaTGConfig(int len, BYTE *buf, int *respLen, BYTE *respBuf);
extern int wfaSendLongFile(int fromSockfd, int streamId, BYTE *respBuf, int *respLen);

extern int wfaImprovePerfSendLongFile(int fromSockfd, int streamId, BYTE *respBuf, int *respLen);

extern int wfaRecvFile(int mySockfi, int profId, char *buf);
extern int wfaTGRecvStart(int len, BYTE *parms, int *respLen, BYTE *respBuf);
extern int wfaTGRecvStop(int len, BYTE *parms, int *respLen, BYTE *respBuf);
extern int wfaTGSendStart(int len, BYTE *parms, int *respLen, BYTE *respBuf);
extern int wfaTGReset(int len, BYTE *parms, int *respLen, BYTE *respBuf);
extern int wfaSendShortFile(int fromSockfd, int profId, BYTE *buf, int size, BYTE *respBuf, int *respLen);
extern int wfaFlushSockQueue(int profId);
extern int wfaTGSendPing(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf);
extern int wfaTGStopPing(int len, BYTE *caCmdBuf, int *respLen, BYTE *respBuf);

#endif /* _WFA_TG_H */
